#ifndef DIFFRACTION_H
#define DIFFRACTION_H

#include <windows.h>
#include "colormap.h"
#include "loadbmp.h"
#include "fourier.h"
#include "parameters.h"

class Diffraction
{
protected:
    HWND _hwnd;
    CRaster *_bmp;
    ColorMap *_cmap;
    Fourier *_four;
    double *_data, *_dataAbs;
    unsigned long *_nn;
    int _ndim, _isign;
    double _dataMin, _dataMax;
    
    void CreateData();
    void NumericalSolution(const Parameters *parameters);
    void AbsoluteValue();
    void FindMinMax();
    void ShiftData();
    void ReplaceData(const Parameters *parameters, bool doShift = true);
    
public:
    Diffraction(HWND hwnd, CRaster *bmp, ColorMap *cmap);
    Diffraction(const Diffraction &rhs);
    ~Diffraction();
    Diffraction &operator=(const Diffraction &rhs);
    void DoDiffraction(const Parameters *parameters);
    void ReloadMap(const Parameters *parameters);
    void ReloadMap(const Parameters *parameters, ColorMap *newMap);
    operator HWND() { return _hwnd; }
};

#endif // DIFFRACTION_H
