#include "colormap.h"
#include "winexception.h"
#include "ressources.h"

ColorMap::ColorMap(): _IDmap(ID_NO_MAP), _size(0)
{}

ColorMap::ColorMap(int IDmap): _IDmap(IDmap)
{
    SearchForMapFromID();
}

ColorMap::ColorMap(const ColorMap &rhs):
    _IDmap(rhs._IDmap), _size(rhs._size), map(rhs.map)
{}

ColorMap::~ColorMap()
{}

ColorMap &ColorMap::operator=(const ColorMap &rhs)
{
    if(&rhs != this)
      {
      _IDmap = rhs._IDmap;
      _size = rhs._size;
    
      SearchForMapFromID();
      }
    return (*this);
}

void ColorMap::SetMap(int IDmap)
{
    _IDmap = IDmap;
    SearchForMapFromID();
}

int ColorMap::GetIDmap() const
{
    return _IDmap;
}

size_t ColorMap::GetSize() const
{
    return _size;
}

//
// Fonctions prives
//

// Carte des couleur "pink" provenant de
// Matlab R2007a. Version 7.4.0.287
// 29 janvier 2007.
static const double PinkColorMapDef[3*64] = {
    0.1179,         0,         0,
    0.1959,    0.1029,    0.1029,
    0.2507,    0.1455,    0.1455,
    0.2955,    0.1782,    0.1782,
    0.3343,    0.2057,    0.2057,
    0.3691,    0.2300,    0.2300,
    0.4009,    0.2520,    0.2520,
    0.4303,    0.2722,    0.2722,
    0.4579,    0.2910,    0.2910,
    0.4839,    0.3086,    0.3086,
    0.5085,    0.3253,    0.3253,
    0.5320,    0.3412,    0.3412,
    0.5546,    0.3563,    0.3563,
    0.5762,    0.3709,    0.3709,
    0.5971,    0.3849,    0.3849,
    0.6172,    0.3984,    0.3984,
    0.6367,    0.4115,    0.4115,
    0.6557,    0.4241,    0.4241,
    0.6741,    0.4364,    0.4364,
    0.6920,    0.4484,    0.4484,
    0.7094,    0.4600,    0.4600,
    0.7265,    0.4714,    0.4714,
    0.7431,    0.4825,    0.4825,
    0.7594,    0.4933,    0.4933,
    0.7664,    0.5175,    0.5040,
    0.7732,    0.5407,    0.5143,
    0.7800,    0.5628,    0.5245,
    0.7868,    0.5842,    0.5345,
    0.7935,    0.6048,    0.5443,
    0.8001,    0.6247,    0.5540,
    0.8067,    0.6440,    0.5634,
    0.8133,    0.6627,    0.5727,
    0.8197,    0.6809,    0.5819,
    0.8262,    0.6986,    0.5909,
    0.8325,    0.7159,    0.5998,
    0.8389,    0.7328,    0.6086,
    0.8452,    0.7493,    0.6172,
    0.8514,    0.7655,    0.6257,
    0.8576,    0.7813,    0.6341,
    0.8637,    0.7968,    0.6424,
    0.8698,    0.8120,    0.6506,
    0.8759,    0.8270,    0.6587,
    0.8819,    0.8416,    0.6667,
    0.8879,    0.8560,    0.6746,
    0.8938,    0.8702,    0.6824,
    0.8997,    0.8842,    0.6901,
    0.9056,    0.8979,    0.6977,
    0.9114,    0.9114,    0.7052,
    0.9172,    0.9172,    0.7272,
    0.9230,    0.9230,    0.7485,
    0.9287,    0.9287,    0.7692,
    0.9344,    0.9344,    0.7893,
    0.9400,    0.9400,    0.8090,
    0.9456,    0.9456,    0.8282,
    0.9512,    0.9512,    0.8469,
    0.9567,    0.9567,    0.8653,
    0.9623,    0.9623,    0.8832,
    0.9677,    0.9677,    0.9008,
    0.9732,    0.9732,    0.9181,
    0.9786,    0.9786,    0.9351,
    0.9840,    0.9840,    0.9517,
    0.9894,    0.9894,    0.9681,
    0.9947,    0.9947,    0.9842,
    1.0000,    1.0000,    1.0000 };
    
// Carte des couleur "hot" provenant de
// Matlab R2007a. Version 7.4.0.287
// 29 janvier 2007.
static const double HotColorMapDef[3*64] = {
    0.0417,         0.0,         0.0,
    0.0833,         0.0,         0.0,
    0.1250,         0.0,         0.0,
    0.1667,         0.0,         0.0,
    0.2083,         0.0,         0.0,
    0.2500,         0.0,         0.0,
    0.2917,         0.0,         0.0,
    0.3333,         0.0,         0.0,
    0.3750,         0.0,         0.0,
    0.4167,         0.0,         0.0,
    0.4583,         0.0,         0.0,
    0.5000,         0.0,         0.0,
    0.5417,         0.0,         0.0,
    0.5833,         0.0,         0.0,
    0.6250,         0.0,         0.0,
    0.6667,         0.0,         0.0,
    0.7083,         0.0,         0.0,
    0.7500,         0.0,         0.0,
    0.7917,         0.0,         0.0,
    0.8333,         0.0,         0.0,
    0.8750,         0.0,         0.0,
    0.9167,         0.0,         0.0,
    0.9583,         0.0,         0.0,
    1.0000,         0.0,         0.0,
    1.0000,    0.0417,         0.0,
    1.0000,    0.0833,         0.0,
    1.0000,    0.1250,         0.0,
    1.0000,    0.1667,         0.0,
    1.0000,    0.2083,         0.0,
    1.0000,    0.2500,         0.0,
    1.0000,    0.2917,         0.0,
    1.0000,    0.3333,         0.0,
    1.0000,    0.3750,         0.0,
    1.0000,    0.4167,         0.0,
    1.0000,    0.4583,         0.0,
    1.0000,    0.5000,         0.0,
    1.0000,    0.5417,         0.0,
    1.0000,    0.5833,         0.0,
    1.0000,    0.6250,         0.0,
    1.0000,    0.6667,         0.0,
    1.0000,    0.7083,         0.0,
    1.0000,    0.7500,         0.0,
    1.0000,    0.7917,         0.0,
    1.0000,    0.8333,         0.0,
    1.0000,    0.8750,         0.0,
    1.0000,    0.9167,         0.0,
    1.0000,    0.9583,         0.0,
    1.0000,    1.0000,         0.0,
    1.0000,    1.0000,    0.0625,
    1.0000,    1.0000,    0.1250,
    1.0000,    1.0000,    0.1875,
    1.0000,    1.0000,    0.2500,
    1.0000,    1.0000,    0.3125,
    1.0000,    1.0000,    0.3750,
    1.0000,    1.0000,    0.4375,
    1.0000,    1.0000,    0.5000,
    1.0000,    1.0000,    0.5625,
    1.0000,    1.0000,    0.6250,
    1.0000,    1.0000,    0.6875,
    1.0000,    1.0000,    0.7500,
    1.0000,    1.0000,    0.8125,
    1.0000,    1.0000,    0.8750,
    1.0000,    1.0000,    0.9375,
    1.0000,    1.0000,    1.0000};

// Carte des couleur "jet" provenant de
// Matlab R2007a. Version 7.4.0.287
// 29 janvier 2007.
static double JetColorMapDef[3*64] = {
         0,         0,    0.5625,
         0,         0,    0.6250,
         0,         0,    0.6875,
         0,         0,    0.7500,
         0,         0,    0.8125,
         0,         0,    0.8750,
         0,         0,    0.9375,
         0,         0,    1.0000,
         0,    0.0625,    1.0000,
         0,    0.1250,    1.0000,
         0,    0.1875,    1.0000,
         0,    0.2500,    1.0000,
         0,    0.3125,    1.0000,
         0,    0.3750,    1.0000,
         0,    0.4375,    1.0000,
         0,    0.5000,    1.0000,
         0,    0.5625,    1.0000,
         0,    0.6250,    1.0000,
         0,    0.6875,    1.0000,
         0,    0.7500,    1.0000,
         0,    0.8125,    1.0000,
         0,    0.8750,    1.0000,
         0,    0.9375,    1.0000,
         0,    1.0000,    1.0000,
    0.0625,    1.0000,    0.9375,
    0.1250,    1.0000,    0.8750,
    0.1875,    1.0000,    0.8125,
    0.2500,    1.0000,    0.7500,
    0.3125,    1.0000,    0.6875,
    0.3750,    1.0000,    0.6250,
    0.4375,    1.0000,    0.5625,
    0.5000,    1.0000,    0.5000,
    0.5625,    1.0000,    0.4375,
    0.6250,    1.0000,    0.3750,
    0.6875,    1.0000,    0.3125,
    0.7500,    1.0000,    0.2500,
    0.8125,    1.0000,    0.1875,
    0.8750,    1.0000,    0.1250,
    0.9375,    1.0000,    0.0625,
    1.0000,    1.0000,         0,
    1.0000,    0.9375,         0,
    1.0000,    0.8750,         0,
    1.0000,    0.8125,         0,
    1.0000,    0.7500,         0,
    1.0000,    0.6875,         0,
    1.0000,    0.6250,         0,
    1.0000,    0.5625,         0,
    1.0000,    0.5000,         0,
    1.0000,    0.4375,         0,
    1.0000,    0.3750,         0,
    1.0000,    0.3125,         0,
    1.0000,    0.2500,         0,
    1.0000,    0.1875,         0,
    1.0000,    0.1250,         0,
    1.0000,    0.0625,         0,
    1.0000,         0,         0,
    0.9375,         0,         0,
    0.8750,         0,         0,
    0.8125,         0,         0,
    0.7500,         0,         0,
    0.6875,         0,         0,
    0.6250,         0,         0,
    0.5625,         0,         0,
    0.5000,         0,         0};

// Carte des couleur "HSV" provenant de
// Matlab R2007a. Version 7.4.0.287
// 29 janvier 2007.
static double HSVColorMapDef[3*64] = {
    1.0000,         0,         0,
    1.0000,    0.0938,         0,
    1.0000,    0.1875,         0,
    1.0000,    0.2813,         0,
    1.0000,    0.3750,         0,
    1.0000,    0.4688,         0,
    1.0000,    0.5625,         0,
    1.0000,    0.6563,         0,
    1.0000,    0.7500,         0,
    1.0000,    0.8438,         0,
    1.0000,    0.9375,         0,
    0.9688,    1.0000,         0,
    0.8750,    1.0000,         0,
    0.7813,    1.0000,         0,
    0.6875,    1.0000,         0,
    0.5938,    1.0000,         0,
    0.5000,    1.0000,         0,
    0.4063,    1.0000,         0,
    0.3125,    1.0000,         0,
    0.2188,    1.0000,         0,
    0.1250,    1.0000,         0,
    0.0313,    1.0000,         0,
         0,    1.0000,    0.0625,
         0,    1.0000,    0.1563,
         0,    1.0000,    0.2500,
         0,    1.0000,    0.3438,
         0,    1.0000,    0.4375,
         0,    1.0000,    0.5313,
         0,    1.0000,    0.6250,
         0,    1.0000,    0.7188,
         0,    1.0000,    0.8125,
         0,    1.0000,    0.9063,
         0,    1.0000,    1.0000,
         0,    0.9063,    1.0000,
         0,    0.8125,    1.0000,
         0,    0.7188,    1.0000,
         0,    0.6250,    1.0000,
         0,    0.5313,    1.0000,
         0,    0.4375,    1.0000,
         0,    0.3438,    1.0000,
         0,    0.2500,    1.0000,
         0,    0.1563,    1.0000,
         0,    0.0625,    1.0000,
    0.0313,         0,    1.0000,
    0.1250,         0,    1.0000,
    0.2188,         0,    1.0000,
    0.3125,         0,    1.0000,
    0.4063,         0,    1.0000,
    0.5000,         0,    1.0000,
    0.5938,         0,    1.0000,
    0.6875,         0,    1.0000,
    0.7813,         0,    1.0000,
    0.8750,         0,    1.0000,
    0.9688,         0,    1.0000,
    1.0000,         0,    0.9375,
    1.0000,         0,    0.8438,
    1.0000,         0,    0.7500,
    1.0000,         0,    0.6563,
    1.0000,         0,    0.5625,
    1.0000,         0,    0.4688,
    1.0000,         0,    0.3750,
    1.0000,         0,    0.2813,
    1.0000,         0,    0.1875,
    1.0000,         0,    0.0938};

// Carte des couleur "gray" provenant de
// Matlab R2007a. Version 7.4.0.287
// 29 janvier 2007.
static double GrayColorMapDef[3*64] = {
         0,         0,         0,
    0.0159,    0.0159,    0.0159,
    0.0317,    0.0317,    0.0317,
    0.0476,    0.0476,    0.0476,
    0.0635,    0.0635,    0.0635,
    0.0794,    0.0794,    0.0794,
    0.0952,    0.0952,    0.0952,
    0.1111,    0.1111,    0.1111,
    0.1270,    0.1270,    0.1270,
    0.1429,    0.1429,    0.1429,
    0.1587,    0.1587,    0.1587,
    0.1746,    0.1746,    0.1746,
    0.1905,    0.1905,    0.1905,
    0.2063,    0.2063,    0.2063,
    0.2222,    0.2222,    0.2222,
    0.2381,    0.2381,    0.2381,
    0.2540,    0.2540,    0.2540,
    0.2698,    0.2698,    0.2698,
    0.2857,    0.2857,    0.2857,
    0.3016,    0.3016,    0.3016,
    0.3175,    0.3175,    0.3175,
    0.3333,    0.3333,    0.3333,
    0.3492,    0.3492,    0.3492,
    0.3651,    0.3651,    0.3651,
    0.3810,    0.3810,    0.3810,
    0.3968,    0.3968,    0.3968,
    0.4127,    0.4127,    0.4127,
    0.4286,    0.4286,    0.4286,
    0.4444,    0.4444,    0.4444,
    0.4603,    0.4603,    0.4603,
    0.4762,    0.4762,    0.4762,
    0.4921,    0.4921,    0.4921,
    0.5079,    0.5079,    0.5079,
    0.5238,    0.5238,    0.5238,
    0.5397,    0.5397,    0.5397,
    0.5556,    0.5556,    0.5556,
    0.5714,    0.5714,    0.5714,
    0.5873,    0.5873,    0.5873,
    0.6032,    0.6032,    0.6032,
    0.6190,    0.6190,    0.6190,
    0.6349,    0.6349,    0.6349,
    0.6508,    0.6508,    0.6508,
    0.6667,    0.6667,    0.6667,
    0.6825,    0.6825,    0.6825,
    0.6984,    0.6984,    0.6984,
    0.7143,    0.7143,    0.7143,
    0.7302,    0.7302,    0.7302,
    0.7460,    0.7460,    0.7460,
    0.7619,    0.7619,    0.7619,
    0.7778,    0.7778,    0.7778,
    0.7937,    0.7937,    0.7937,
    0.8095,    0.8095,    0.8095,
    0.8254,    0.8254,    0.8254,
    0.8413,    0.8413,    0.8413,
    0.8571,    0.8571,    0.8571,
    0.8730,    0.8730,    0.8730,
    0.8889,    0.8889,    0.8889,
    0.9048,    0.9048,    0.9048,
    0.9206,    0.9206,    0.9206,
    0.9365,    0.9365,    0.9365,
    0.9524,    0.9524,    0.9524,
    0.9683,    0.9683,    0.9683,
    0.9841,    0.9841,    0.9841,
    1.0000,    1.0000,    1.0000};

// Carte des couleur "gray" (inverse) provenant de
// Matlab R2007a. Version 7.4.0.287
// 29 janvier 2007.
static double GrayInvColorMapDef[3*64] = {
    1.0000,    1.0000,    1.0000,
    0.9841,    0.9841,    0.9841,
    0.9683,    0.9683,    0.9683,
    0.9524,    0.9524,    0.9524,
    0.9365,    0.9365,    0.9365,
    0.9206,    0.9206,    0.9206,
    0.9048,    0.9048,    0.9048,
    0.8889,    0.8889,    0.8889,
    0.8730,    0.8730,    0.8730,
    0.8571,    0.8571,    0.8571,
    0.8413,    0.8413,    0.8413,
    0.8254,    0.8254,    0.8254,
    0.8095,    0.8095,    0.8095,
    0.7937,    0.7937,    0.7937,
    0.7778,    0.7778,    0.7778,
    0.7619,    0.7619,    0.7619,
    0.7460,    0.7460,    0.7460,
    0.7302,    0.7302,    0.7302,
    0.7143,    0.7143,    0.7143,
    0.6984,    0.6984,    0.6984,
    0.6825,    0.6825,    0.6825,
    0.6667,    0.6667,    0.6667,
    0.6508,    0.6508,    0.6508,
    0.6349,    0.6349,    0.6349,
    0.6190,    0.6190,    0.6190,
    0.6032,    0.6032,    0.6032,
    0.5873,    0.5873,    0.5873,
    0.5714,    0.5714,    0.5714,
    0.5556,    0.5556,    0.5556,
    0.5397,    0.5397,    0.5397,
    0.5238,    0.5238,    0.5238,
    0.5079,    0.5079,    0.5079,
    0.4921,    0.4921,    0.4921,
    0.4762,    0.4762,    0.4762,
    0.4603,    0.4603,    0.4603,
    0.4444,    0.4444,    0.4444,
    0.4286,    0.4286,    0.4286,
    0.4127,    0.4127,    0.4127,
    0.3968,    0.3968,    0.3968,
    0.3810,    0.3810,    0.3810,
    0.3651,    0.3651,    0.3651,
    0.3492,    0.3492,    0.3492,
    0.3333,    0.3333,    0.3333,
    0.3175,    0.3175,    0.3175,
    0.3016,    0.3016,    0.3016,
    0.2857,    0.2857,    0.2857,
    0.2698,    0.2698,    0.2698,
    0.2540,    0.2540,    0.2540,
    0.2381,    0.2381,    0.2381,
    0.2222,    0.2222,    0.2222,
    0.2063,    0.2063,    0.2063,
    0.1905,    0.1905,    0.1905,
    0.1746,    0.1746,    0.1746,
    0.1587,    0.1587,    0.1587,
    0.1429,    0.1429,    0.1429,
    0.1270,    0.1270,    0.1270,
    0.1111,    0.1111,    0.1111,
    0.0952,    0.0952,    0.0952,
    0.0794,    0.0794,    0.0794,
    0.0635,    0.0635,    0.0635,
    0.0476,    0.0476,    0.0476,
    0.0317,    0.0317,    0.0317,
    0.0159,    0.0159,    0.0159,
         0,         0,         0};

void ColorMap::SearchForMapFromID()
{
    switch(_IDmap)
      {
      // Carte des couleur "pink" provenant de
      // Matlab R2007a. Version 7.4.0.287
      // 29 janvier 2007.
      case ID_MAP_PINK:
            _size = 3*64;
            map = (double*)PinkColorMapDef;
      break;
      
      // Carte des couleur "hot" provenant de
      // Matlab R2007a. Version 7.4.0.287
      // 29 janvier 2007.
      case ID_MAP_HOT: 
            _size = 3*64;
            map = (double*)HotColorMapDef;
      break;
            
      // Carte des couleur "jet" provenant de
      // Matlab R2007a. Version 7.4.0.287
      // 29 janvier 2007.
      case ID_MAP_JET:  
            _size = 3*64;
            map = (double*)JetColorMapDef;
      break;
            
      // Carte des couleur "HSV" provenant de
      // Matlab R2007a. Version 7.4.0.287
      // 29 janvier 2007.
      case ID_MAP_HSV:
            _size = 3*64;
            map = (double*)HSVColorMapDef;
      break;
            
      // Carte des couleur "gray" provenant de
      // Matlab R2007a. Version 7.4.0.287
      // 29 janvier 2007.
      case ID_MAP_GRAY:
            _size = 3*64;
            map = (double*)GrayColorMapDef;
      break;
      
      // Carte des couleur "gray" (inverse) provenant de
      // Matlab R2007a. Version 7.4.0.287
      // 29 janvier 2007.
      case ID_MAP_GRAYINV:
            _size = 3*64;
            map = (double*)GrayInvColorMapDef;
      break;
      
      default:
            _size = 0;
            throw WinException("ColorMap: pas de carte dfinie");
      }
}
