#include "canvas.h"

Canvas::Canvas(HDC hdc): _hdc(hdc)
{}

Canvas::Canvas(const Canvas &rhs): _hdc(rhs._hdc)
{}

Canvas::~Canvas()
{}

Canvas &Canvas::operator=(const Canvas &rhs)
{
    if(&rhs != this)
      _hdc = rhs._hdc;
    return (*this);
}

Canvas::operator HDC()
{
    return _hdc;
}

void Canvas::Paint(CRaster const *bmp, int x, int y) const
{
    bmp->GDIPaint(_hdc, x, y);
}
